var camDateTime = {};
var camClock = null;

function toDatetimeHome() {
    document.getElementById("Div_datetimeclock").style.display = "block";
    document.getElementById("Div_ntpsync").style.display = "none";
}

function toSyncNTP() {
    document.getElementById("Div_datetimeclock").style.display = "none";
    document.getElementById("Div_ntpsync").style.display = "block";
}

function toSyncComputer() {
    document.getElementById("Div_datetimeclock").style.display = "none";
    document.getElementById("Div_ntpsync").style.display = "none";
}

function syncTime() {
    var value = document.getElementById("dateTimeSel").value;

    if (value == "syncServer") {
        toSyncNTP();
    } else if (value == "syncPC") {
        toSyncComputer();
    } else {
        toDatetimeHome();
    }
}

function updateDateTimeStaticOption() {
    var x, str;
    for (x = 0; x < 24; x++) {
        str = ("0" + x).slice(-2);
        $("#manualHoursSelect").append($("<option></option>").val(str).text(str));
    }
    for (x = 0; x < 60; x++) {
        str = ("0" + x).slice(-2);
        $("#manualMinutesSelect").append($("<option></option>").val(str).text(str));
        $("#manualSecondsSelect").append($("<option></option>").val(str).text(str));
    }
}

function dateConvertCam(dateobj) {
    var year = dateobj.getFullYear();
    var month = ("0" + (dateobj.getMonth() + 1)).slice(-2);
    var date = ("0" + dateobj.getDate()).slice(-2);
    var hours = ("0" + dateobj.getHours()).slice(-2);
    var minutes = ("0" + dateobj.getMinutes()).slice(-2);
    var seconds = ("0" + dateobj.getSeconds()).slice(-2);

    $("#cameraDateLabel").text([year, month, date].join("/"));
    $("#cameraTimeLabel").text([hours, minutes, seconds].join(":"));

    dateobj.setSeconds(dateobj.getSeconds() + 1);
}

function dateConvertPC() {
    var pcDateNow = new Date();
    var pcDate = new Date();
    while (pcDate.getTime() === pcDateNow.getTime()) {
        pcDate = new Date();
    }
    var year = pcDate.getFullYear();
    var month = ("0" + (pcDate.getMonth() + 1)).slice(-2);
    var date = ("0" + pcDate.getDate()).slice(-2);
    var hours = ("0" + pcDate.getHours()).slice(-2);
    var minutes = ("0" + pcDate.getMinutes()).slice(-2);
    var seconds = ("0" + pcDate.getSeconds()).slice(-2);
    var converted_date = "";

    converted_date = [year, month, date].join("/");
    $("#manualDateInput").val(converted_date);
    $("#manualHoursSelect").val(hours);
    $("#manualMinutesSelect").val(minutes);
    $("#manualSecondsSelect").val(seconds);
}

function saveDatetimeSettings() {
    var cgiParam = {};
    var value = document.getElementById("dateTimeSel").value;
    var timeToSet = "";
    addTime = 0;
    urlToSend = "/command/system.cgi?";

    if (value == "syncServer") {
        cgiParam.NtpServer = $("#sntpServerInput").val();
        cgiParam.TimeZoneIndex = $("#timeZoneSelect").val();
        cgiParam.DstMode = ($("#dayLightCheckboxInput").is(':checked') == true) ? "on" : "off";
        AddParameter("NtpServer", cgiParam.NtpServer);
        AddParameter("TimeZoneIndex", cgiParam.TimeZoneIndex);
        AddParameter("DstMode", cgiParam.DstMode);
        AddParameter("NtpService", "on");
    } else if (value == "syncPC") {
        var dateToSet = new Date();
        var year = dateToSet.getFullYear() - 2000;
        var month = ((dateToSet.getMonth() + 1) < 10) ? "0" + (dateToSet.getMonth() + 1) : (dateToSet.getMonth() + 1).toString();
        var day = (dateToSet.getDate() < 10) ? "0" + dateToSet.getDate() : dateToSet.getDate().toString();
        var hour = (dateToSet.getHours() < 10) ? "0" + dateToSet.getHours() : dateToSet.getHours().toString();
        var min = (dateToSet.getMinutes() < 10) ? "0" + dateToSet.getMinutes() : dateToSet.getMinutes().toString();
        var sec = (dateToSet.getSeconds() < 10) ? "0" + dateToSet.getSeconds() : dateToSet.getSeconds().toString();
        var wday = dateToSet.getDay();
        var timeToSet = "";
        if (year < 20) {
            timeToSet = "2001010000003";
        } else {
            year = year.toString();
            timeToSet = year + month + day + hour + min + sec + wday;
        }
        AddParameter("Time", timeToSet);
        AddParameter("NtpService", "off");
    } else {
        var dateArray = $("#manualDateInput").val().split("/");
        var year = dateArray[0] - 2000;
        var month = (dateArray[1]).toString();
        var day = (dateArray[2]).toString();
        var hour = $("#manualHoursSelect").val().toString();
        var min = $("#manualMinutesSelect").val().toString();
        var sec = $("#manualSecondsSelect").val().toString();
        if (year < 20) {
            timeToSet = "2001010000003";
        } else {
            year = year.toString();
            timeToSet = year + month + day + hour + min + sec + "0";
        }
        AddParameter("Time", timeToSet);
        AddParameter("NtpService", "off");
    }

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send Datetime Setting Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            addTime = 0;
            console.log("Datetime settings saved to " + cameraSettings.CameraName);
            reloadDatetime();
            UnblockUIforPage();
        }
    });
}

function reloadDatetime() {
    $.ajax({
        url: "/command/inquiry.cgi?inqjs=main&inqjs=network&inqjs=system",
        type: "GET",
        error: function (xhr) {
            console.log("Get datetime info fail");
        },
        success: function (response) {
            const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
            var result = [];
            while (result = regEx.exec(response)) {
                cameraSettings[result[1]] = result[2];
            }

            $("#sntpServerInput").val(cameraSettings.NtpServer);
            $("#timeZoneSelect").val(cameraSettings.TimeZoneIndex);
            $("#dayLightCheckboxInput").prop("checked", OnOff2BoolMap.get(cameraSettings.DstMode));

            if (cameraSettings.NtpService == "on" && $("#dateTimeSel").val() != "syncServer") {
                $("#dateTimeSel").val("syncServer");
                syncTime();
            } else if (cameraSettings.NtpService == "off" && $("#dateTimeSel").val() == "syncServer") {
                $("#dateTimeSel").val("manual");
                syncTime();
            }

            var year = parseInt(cameraSettings.Time.slice(0, 2)) + 2000;
            var mon = parseInt(cameraSettings.Time.slice(2, 4)) - 1;
            var day = parseInt(cameraSettings.Time.slice(4, 6));
            var hour = parseInt(cameraSettings.Time.slice(6, 8));
            var min = parseInt(cameraSettings.Time.slice(8, 10));
            var sec = parseInt(cameraSettings.Time.slice(10, 12));
            camDateTime = new Date(year, mon, day, hour, min, sec);

            if (camClock != null) {
                clearInterval(camClock);
                camClock = null;
            }
            dateConvertCam(camDateTime);
            camClock = setInterval(dateConvertCam, 1000, camDateTime);
        }
    })
}

function openDatetime() {
    $("#DivMainPage").load("./page/datetime.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;

        updateDateTimeStaticOption();

        $.ajax({
            url: "/command/inquiry.cgi?inqjs=system",
            type: "GET",
            error: function (xhr) {
                console.log("Get datetime info fail");
            },
            success: function (response) {
                const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
                var result = [];
                while (result = regEx.exec(response)) {
                    cameraSettings[result[1]] = result[2];
                }

                if (cameraSettings.NtpService == "on") {
                    $("#dateTimeSel").val("syncServer");
                } else if (cameraSettings.NtpService == "off") {
                    $("#dateTimeSel").val("manual");
                }
                $("#sntpServerInput").val(cameraSettings.NtpServer);
                $("#timeZoneSelect").val(cameraSettings.TimeZoneIndex);
                $("#dayLightCheckboxInput").prop("checked", OnOff2BoolMap.get(cameraSettings.DstMode));
                syncTime();
                $("#manualDateInput").datepicker({
                    format: "yyyy/mm/dd",
                    autoclose: true
                }).change(function () {
                    function formatDate(date) {
                        var d = new Date(date),
                            month = '' + (d.getMonth() + 1),
                            day = '' + d.getDate(),
                            year = d.getFullYear();
                        if (month.length < 2) month = month;
                        if (day.length < 2) day = day;
                        return [year, month, day].join('/');
                    }
                    document.getElementById("manualDateInput").value = formatDate(document.getElementById("manualDateInput").value);
                });
                var year = parseInt(cameraSettings.Time.slice(0, 2)) + 2000;
                var mon = parseInt(cameraSettings.Time.slice(2, 4)) - 1;
                var day = parseInt(cameraSettings.Time.slice(4, 6));
                var hour = parseInt(cameraSettings.Time.slice(6, 8));
                var min = parseInt(cameraSettings.Time.slice(8, 10));
                var sec = parseInt(cameraSettings.Time.slice(10, 12));
                camDateTime = new Date(year, mon, day, hour, min, sec);

                dateConvertCam(camDateTime);
                if (camClock != null) {
                    clearInterval(camClock);
                    camClock = null;
                }
                camClock = setInterval(dateConvertCam, 1000, camDateTime);

                dateConvertPC();

                $("#applyButton").on('click', saveDatetimeSettings);
                $("#cancelButton").on('click', function () {
                    reloadDatetime();
                    dateConvertPC();
                });
            }
        });
    });
}
